/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.sharing;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import mod.chiselsandbits.api.client.sharing.PatternIOException;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.CompressionUtils;
import mod.chiselsandbits.utils.FileUtils;
import mod.chiselsandbits.utils.TextureUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_777;

public final class PatternSharingExecutor {
    private PatternSharingExecutor() {
        throw new IllegalStateException("Can not instantiate an instance of: PatternSharingExecutor. This is a utility class");
    }

    static void doSavePattern(IMultiStateItemStack multiStateItemStack, String patternName) {
        try {
            PatternSharingExecutor.savePattern(multiStateItemStack, patternName);
        }
        catch (PatternIOException e) {
            class_310.method_1551().field_1724.method_9203(e.getErrorMessage(), class_156.field_25140);
        }
    }

    private static void savePattern(IMultiStateItemStack multiStateItemStack, String patternName) throws PatternIOException {
        byte[] textureAtlasData = PatternSharingExecutor.getBlockTextureAtlasData();
        ModelData modelData = PatternSharingExecutor.getModelQuadData(multiStateItemStack);
        byte[] chiselData = PatternSharingExecutor.getChiselData(multiStateItemStack);
        String dataString = PatternSharingExecutor.toDataString(textureAtlasData, modelData, chiselData);
        PatternSharingExecutor.writePatternDataToDisk(patternName, dataString);
    }

    private static void writePatternDataToDisk(String patternName, String dataString) throws PatternIOException {
        String encodedString = Base64.getEncoder().encodeToString(dataString.getBytes());
        Path targetPath = Paths.get(IClientConfiguration.getInstance().getPatternExportPath().get(), patternName + ".cbsbp");
        try {
            byte[] uncompressedData = encodedString.getBytes();
            byte[] compressedData = CompressionUtils.compress(uncompressedData);
            Files.write(FileUtils.ensureFileWritable(targetPath), compressedData, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternExportFailedCouldNotWriteFile.getText(), "Could not write pattern data file to disk", e);
        }
    }

    private static String toDataString(byte[] textureAtlasData, ModelData modelData, byte[] chiselData) {
        Gson gson = new GsonBuilder().create();
        JsonObject returnObject = new JsonObject();
        returnObject.addProperty("version", "1.0");
        returnObject.addProperty("textureAtlas", Base64.getEncoder().encodeToString(textureAtlasData));
        returnObject.add("modelData", gson.toJsonTree((Object)modelData));
        returnObject.addProperty("chiselData", Base64.getEncoder().encodeToString(chiselData));
        return gson.toJson((JsonElement)returnObject);
    }

    private static byte[] getChiselData(IMultiStateItemStack multiStateItemStack) throws PatternIOException {
        class_2487 compoundTag = (class_2487)multiStateItemStack.serializeNBT();
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        try {
            class_2507.method_10628((class_2487)compoundTag, (DataOutput)dataOutput);
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternExportFailedCouldNotWriteChiselData.getText(), "Failed to write chisel data to memory.", e);
        }
        return dataOutput.toByteArray();
    }

    private static byte[] getBlockTextureAtlasData() throws PatternIOException {
        class_1011 currentAtlas = TextureUtils.getNativeImageFromTexture(class_1723.field_21668);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(byteArrayOutputStream);
        try {
            if (currentAtlas.method_24032(channel)) {
                return byteArrayOutputStream.toByteArray();
            }
            throw new PatternIOException((class_2561)LocalStrings.PatternExportFailedGenericAtlasWriteFailure.getText(), "Failed to process the in-memory block atlas texture.");
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternExportFailedCouldNotWriteAtlas.getText(), "Failed to write the current block texture atlas to disk.", e);
        }
    }

    private static ModelData getModelQuadData(IMultiStateItemStack multiStateItemStack) {
        class_1799 blockStack = multiStateItemStack.toBlockStack();
        class_1087 bakedmodel = class_310.method_1551().method_1480().method_4019(blockStack, (class_1937)class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0);
        Random random = new Random();
        ModelData modelData = new ModelData(Arrays.stream(class_2350.values()).collect(Collectors.toMap(Function.identity(), direction -> bakedmodel.method_4707(null, direction, random).stream().map(QuadData::new).collect(Collectors.toList()))), bakedmodel.method_4707(null, null, random).stream().map(QuadData::new).collect(Collectors.toList()));
        return modelData;
    }

    static Either<IMultiStateItemStack, PatternIOException> doImportPattern(String patternName) {
        try {
            return Either.left((Object)PatternSharingExecutor.importPattern(patternName));
        }
        catch (PatternIOException e) {
            return Either.right((Object)e);
        }
    }

    private static IMultiStateItemStack importPattern(String patternName) throws PatternIOException {
        String patternData = PatternSharingExecutor.loadPatternDataFromDisk(patternName);
        return PatternSharingExecutor.getChiselData(patternData);
    }

    private static String loadPatternDataFromDisk(String patternName) throws PatternIOException {
        byte[] uncompressedData;
        byte[] compressedData;
        Path targetPath = Paths.get(IClientConfiguration.getInstance().getPatternExportPath().get(), patternName + ".cbsbp");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedFileNotFound.getText(), "Failed to find the pattern file at the specified path.");
        }
        try {
            compressedData = Files.readAllBytes(targetPath);
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedCouldNotReadFile.getText(), "Failed to read the pattern file from disk.", e);
        }
        try {
            uncompressedData = CompressionUtils.decompress(compressedData);
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedCouldNotDecompressFile.getText(), "Could not decompress the pattern file from disk.", e);
        }
        catch (DataFormatException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedCompressedDataInWrongFormat.getText(), "Could not decompress the pattern file from disk, the data is stored in an unknown format.", e);
        }
        byte[] decodedData = Base64.getDecoder().decode(uncompressedData);
        return new String(decodedData);
    }

    private static IMultiStateItemStack getChiselData(String dataString) throws PatternIOException {
        Gson gson = new GsonBuilder().create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(dataString, JsonObject.class);
        String version = jsonObject.get("version").getAsString();
        if (version.equals("1.0")) {
            return PatternSharingExecutor.getVersion1ChiselData(jsonObject);
        }
        throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedUnknownVersion.getText(), "The pattern file is stored in an unknown version.");
    }

    private static IMultiStateItemStack getVersion1ChiselData(JsonObject dataObject) throws PatternIOException {
        class_2487 compoundTag;
        String encodedChiselString = dataObject.get("chiselData").getAsString();
        byte[] chiselData = Base64.getDecoder().decode(encodedChiselString);
        ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])chiselData);
        try {
            compoundTag = class_2507.method_10627((DataInput)byteArrayDataInput);
        }
        catch (IOException e) {
            throw new PatternIOException((class_2561)LocalStrings.PatternImportFailedInvalidChiselData.getText(), "The chisel data is stored in an invalid format.");
        }
        return new SingleBlockMultiStateItemStack((class_1792)ModItems.SINGLE_USE_PATTERN_ITEM.get(), compoundTag);
    }

    private static final class ModelData {
        final Map<class_2350, List<QuadData>> directionalQuads;
        final List<QuadData> genericData;

        private ModelData(Map<class_2350, List<QuadData>> directionalQuads, List<QuadData> genericData) {
            this.directionalQuads = directionalQuads;
            this.genericData = genericData;
        }
    }

    private static final class QuadData {
        private final int[] vertices;
        private final int tintIndex;
        private final class_2350 direction;
        private final boolean shade;

        private QuadData(class_777 source) {
            this.vertices = source.method_3357();
            this.tintIndex = source.method_3359();
            this.direction = source.method_3358();
            this.shade = source.method_24874();
        }

        public int[] getVertices() {
            return this.vertices;
        }

        public int getTintIndex() {
            return this.tintIndex;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public boolean isShade() {
            return this.shade;
        }
    }
}

